#include <bits/stdc++.h>

#ifdef _DEBUG
#define D(X) X
#else
#define D(X)
#endif

#define INF32 INT_MAX
#define NINF32 INT_MIN
#define INF64 LONG_MAX
#define NINF64 LONG_MIN

using namespace std;

typedef int i32;
typedef unsigned int u32;

typedef long long i64;
typedef unsigned long long u64;

typedef unordered_set<u32> usu32;


static u32 deepest=0;
static u32 deep_depth=0;
static u32 diamater[3005] = {};

void RES_FAIL(){
    u64* mem_fail;
    mem_fail[INF64] = 0xdeadbeaf;
}

bool dfs_m(usu32* t,u32 tren,u32 pret, u32 depth) {
    bool on_diamater=0;
    if(depth>deep_depth){
        deepest = tren;
        deep_depth = depth;
        on_diamater = 1;
        diamater[depth] = tren;
    }
    for(const auto &x : t[tren]) {
        if(x != pret) {
            on_diamater |= dfs_m(t,x,tren,depth+1);
        }
    }
    if(on_diamater) {
        diamater[depth] = tren;
    }
    return on_diamater;
}

void dfs(usu32* t,u32 tren,u32 pret, u32 depth) {
    if(depth>deep_depth){
        deepest = tren;
        deep_depth = depth;
    }
    for(const auto &x : t[tren]) {
        if(x != pret) {
            dfs(t,x,tren,depth+1);
        }
    }
    return;
}

pair<u32,u32> get_far(usu32* t,u32 start, u32 pret, bool modify) {
    deepest = start;
    deep_depth = 0;
    if(modify) {
        dfs_m(t,start, pret, 0);
    } else {
        dfs(t,start, pret, 0);
    }
    return make_pair(deepest,deep_depth);
}



void test_case() {
    u32 n,k;
    cin >> n >> k;
    usu32 t[n];
    for(u32 i=0; i < n-1; i++) {
        u32 a,b;
        cin >> a >> b;
        a--;
        b--;
        if(a>=n||b>=n){
            RES_FAIL();
        }
        t[a].insert(b);
        t[b].insert(a);
    }
    for(u32 l = 0;l<k;l++){
        u32 diam_node1 = get_far(t,0,0,false).first;
        pair<u32,u32> tmp_pair = get_far(t,diam_node1,diam_node1,true);
        u32 diam_node2 = tmp_pair.first;
        u32 diam_len = tmp_pair.second + 1;
        D(cout << "Diameter length: " << diam_len << endl);
        u32 best_switch = 0;
        u32 best_switch_gain = 0;
        u32 best_switch_parent = 0;
        for(u32 i = 1;i<diam_len;i++){
            for(const auto &x: t[diamater[i]]) {
                if(x == diamater[i-1] || x==diamater[i+1]) continue;
                tmp_pair = get_far(t,x,diamater[i],0);
                if(best_switch_gain<tmp_pair.second+1) {
                    best_switch_gain = tmp_pair.second+1;
                    best_switch = x;
                    best_switch_parent = diamater[i];

                }
            }
        }
        if(best_switch != best_switch_parent) {
            D(cout << "Switching: " << best_switch << "\nfrom: " << best_switch_parent << "\nwith: " << diam_node2 << endl);
            t[best_switch].erase(best_switch_parent);
            t[best_switch_parent].erase(best_switch);
            t[diam_node2].insert(best_switch);
            t[best_switch].insert(diam_node2);
        } else {
            break;
        }
    }
    u32 diam_node1 = get_far(t,0,0,false).first;

    cout <<get_far(t,diam_node1,diam_node1,0).second << endl;

}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    i32 T;
    cin >> T;
    for(i32 i = 0; i < T; i++) {
        deepest = 0;
        deep_depth = 0;
        test_case();

    }
    return 0;
}